module alu_4b_tb ();
reg[1:0] dS;
reg[3:0] dP,dQ;
wire[3:0] mY;
reg[3:0] cY;

integer loop, ecnt;

initial begin
  ecnt = 0;
  // TASK: try to put dS assignment in a loop! => shorter code!
  dS = 2'b00; // test add
  for (loop=0;loop<256;loop++) begin
    {dP,dQ} = loop;
    #5;
    cY = dP + dQ;
    if (cY!=mY) begin
      ecnt = ecnt + 1;
      $display("** Add error (%x+%x=%x@%x)!",dP,dQ,mY,cY);
    end
  end
  dS = 2'b01; // test sub
  for (loop=0;loop<256;loop++) begin
    {dP,dQ} = loop;
    #5;
    cY = dP - dQ;
    if (cY!=mY) begin
      ecnt = ecnt + 1;
      $display("** Sub error (%x-%x=%x@%x)!",dP,dQ,mY,cY);
    end
  end
  dS = 2'b10; // test and
  for (loop=0;loop<256;loop++) begin
    {dP,dQ} = loop;
    #5;
    cY = dP & dQ;
    if (cY!=mY) begin
      ecnt = ecnt + 1;
      $display("** And error (%x&%x=%x@%x)!",dP,dQ,mY,cY);
    end
  end
  dS = 2'b11; // test or
  for (loop=0;loop<256;loop++) begin
    {dP,dQ} = loop;
    #5;
    cY = dP | dQ;
    if (cY!=mY) begin
      ecnt = ecnt + 1;
      $display("** Or error (%x|%x=%x@%x)!",dP,dQ,mY,cY);
    end
  end
  if (ecnt==0) begin
    $display("-- Module alu_4b verified!");
  end
  else begin
    $display("** Module alu_4b with %g error(s)!",ecnt);
  end
end

alu_4b dut (dS,dP,dQ,mY);

endmodule
