module upcore (iclk,irst,ienb,inst,ostt,done);
parameter INSTBITS = 8;
parameter DATABITS = 4;
input iclk,irst,ienb;
input[7:0] inst;
output[3:0] ostt;
output done;
wire[3:0] ostt, tstt;
wire done;

wire[DATABITS-1:0] xdat, opr1, opr2, alu_res;
wire[1:0] src2, src1 ,dst0;
wire[1:0] alu_sel;
wire s2en, s1en, d0en;

regblock4dp regs (iclk,d0en,dst0,s1en,src1,s2en,src2,xdat,opr1,opr2);
alu_4b alud (alu_sel,opr1,opr2,alu_res);
rcount4 step (~iclk,irst,ienb,tstt);
assign ostt = tstt;

wire[INSTBITS-1:0] ireg_dat;
wire ireg_enb;

defparam inst_reg.BITS = INSTBITS;
dreg inst_reg (iclk,ireg_enb,1'b1,inst,ireg_dat);

// generate control logic

//wire[1:0] alu_sel;
assign alu_sel = ireg_dat[3:2];
//wire[1:0] src2, src1 ,dst0;
assign dst0 = ireg_dat[5:4];
assign src1 = ireg_dat[5:4];
assign src2 = ireg_dat[1:0];

wire[DATABITS-1:0] load_val;
assign load_val = ireg_dat[3:0];

wire inst_alu, inst_mov, inst_lod;
assign inst_alu = ireg_dat[7]&~ireg_dat[6];
assign inst_mov = ~ireg_dat[7]&ireg_dat[6];
assign inst_lod = ireg_dat[7]&ireg_dat[6];

//wire[DATABITS-1:0] xdat;
zbuff opt_mov (inst_mov,opr2,xdat);
zbuff opt_alu (inst_alu,alu_res,xdat);
zbuff opt_lod (inst_lod,load_val,xdat);

//wire ireg_enb;
assign ireg_enb = tstt[0]; // state S1 (ILOAD)
//wire s2en, s1en, d0en;
assign d0en = tstt[3]; // state S4 (WRITE)
assign s1en = tstt[1]|tstt[2]|tstt[3] ;
assign s2en = tstt[1] | tstt[2] | tstt[3] ; // state S2 

endmodule











