module regblock4 (iclk,wenb,wadd,renb,radd,idat,odat);
parameter BITS = 4;
input iclk,wenb,renb;
input[1:0] wadd,radd;
input[BITS-1:0] idat;
output[BITS-1:0] odat;
wire[BITS-1:0] odat;

wire[3:0] dw, ew, dr, er;

defparam reg0.BITS = BITS;
defparam reg1.BITS = BITS;
defparam reg2.BITS = BITS;
defparam reg3.BITS = BITS;
dreg reg0 (iclk,ew[0],er[0],idat,odat);
dreg reg1 (iclk,ew[1],er[1],idat,odat);
dreg reg2 (iclk,ew[2],er[2],idat,odat);
dreg reg3 (iclk,ew[3],er[3],idat,odat);

decode24 wdec (wadd,dw);
and_4b wsel (dw,{4{wenb}},ew);

decode24 rdec (radd,dr);
and_4b rsel (dr,{4{renb}},er);

endmodule
