module regblock4_tb ();
parameter BITS = 4;
parameter CLKP = 10;
reg dclk,dwre,drde;
reg[1:0] wsel,rsel;
reg[BITS-1:0] ddat;
wire[BITS-1:0] mdat;

always begin
  #(CLKP/2) dclk = ~dclk;
end

task reg_move ; // call on -ve edge
  input[1:0] wadd, radd; // dst,src
  begin
    // read cycle
    rsel = radd; drde = 1'b1;
    #(CLKP);
    ddat = mdat;
    // write cycle
    wsel = wadd; dwre = 1'b1;
    #(CLKP);
    dwre = 1'b0; drde = 1'b0;
  end
endtask

task reg_hack; // call on -ve edge
  input[1:0] hadd;
  input[BITS-1:0] hdat;
  begin
    // write cycle
    wsel = hadd; dwre = 1'b1;
    ddat = hdat;
    #(CLKP);
    dwre = 1'b0;
  end
endtask

always @(posedge dclk) begin
  if (drde===1'b1) begin
    $display("[%05g] R%g (%b) read value %h@(%b)",
      $time,rsel,rsel,mdat,mdat);
  end
  if (dwre===1'b1) begin
    $display("[%05g] R%g (%b) write value %h@(%b)",
      $time,wsel,wsel,ddat,ddat);
  end
end

task reg_showall;
  begin
    $write("[%05g] Register Contents => { ",$time);
    $write("R0:%b ",dut.reg0.tdat);
    $write("R1:%b ",dut.reg1.tdat);
    $write("R2:%b ",dut.reg2.tdat);
    $write("R3:%b }\n",dut.reg3.tdat);
  end
endtask

initial begin
  // reset conditions
  dclk = 1'b0; dwre = 1'b0; drde = 1'b0;
  reg_showall();
  #(CLKP);
  reg_hack(0,4'ha);
  reg_hack(1,2);
  reg_hack(2,5);
  reg_hack(3,12);
  #(CLKP);
  reg_move(3,0);
  $stop;
end

regblock4 dut (dclk,dwre,wsel,drde,rsel,ddat,mdat);

endmodule
