module regblock4dp (iclk,wenb,wadd,renb,radd,r2nb,r2dd,idat,odat,od2t);
parameter BITS = 4;
input iclk,wenb,renb,r2nb;
input[1:0] wadd,radd,r2dd;
input[BITS-1:0] idat;
output[BITS-1:0] odat, od2t;
wire[BITS-1:0] odat, od2t;

wire[BITS-1:0] tmp0, tmp1, tmp2, tmp3;
wire[3:0] dw, ew, dr, er, dx, ex;

defparam reg0.BITS = BITS;
defparam reg1.BITS = BITS;
defparam reg2.BITS = BITS;
defparam reg3.BITS = BITS;
// output always enable here
dreg reg0 (iclk,ew[0],1'b1,idat,tmp0);
dreg reg1 (iclk,ew[1],1'b1,idat,tmp1);
dreg reg2 (iclk,ew[2],1'b1,idat,tmp2);
dreg reg3 (iclk,ew[3],1'b1,idat,tmp3);

// control output enables here
zbuff op10 (er[0],tmp0,odat);
zbuff op11 (er[1],tmp1,odat);
zbuff op12 (er[2],tmp2,odat);
zbuff op13 (er[3],tmp3,odat);
zbuff op20 (ex[0],tmp0,od2t);
zbuff op21 (ex[1],tmp1,od2t);
zbuff op22 (ex[2],tmp2,od2t);
zbuff op23 (ex[3],tmp3,od2t);

decode24 wdec (wadd,dw);
and_4b wsel (dw,{4{wenb}},ew);

decode24 rdec (radd,dr);
and_4b rsel (dr,{4{renb}},er);

decode24 rd2c (r2dd,dx);
and_4b rs2l (dx,{4{r2nb}},ex);

endmodule
