module dffepc_tb ();

reg dclk,ddat;
reg denb,dpre,dclr;
wire mdat;

// use in tb
// 10TU clock period
parameter CLKP = 10;
always begin
  #(CLKP/2) dclk = ~dclk;
end

// assume @+ve edge dff
// should call this @-ve edge
task dffepc_wr ;
  input integer dbit;
  begin
    ddat = dbit; denb = 1;
    $display("-- [%g] WR-dff:'%b' ",$time,ddat);
    #(CLKP/2); // setup time
    // should latch here
    #(CLKP/2); // hold time
    // 1-cycle
    denb = 0;
  end
endtask

// detect dff output
// can also use mdat!
always @(dut.odat) begin
  $write("[%05g] dffQ=%b\n",$time,dut.odat);
end

initial begin
  //dclk = 1;
  //#(CLKP/2) dff_wr(1);
  dclk = 0; denb = 0; dpre = 0; dclr = 0;
  #(CLKP) dffepc_wr(1'b1);
  #(CLKP);
  // TU=30
  ddat = 1'b0;
  #(CLKP) dffepc_wr(1'b0);
  #(CLKP);
  // test preset
  $display("-- Test preset");
  dpre = 1;
  #(CLKP);
  dpre = 0;
  // test clear
  $display("-- Test clear");
  dclr = 1;
  #(CLKP);
  dclr = 0;
  #(CLKP);
  $stop;
end

dffepc dut (dclk,denb,dpre,dclr,ddat,mdat);

endmodule
