module dmux21_tb ();
parameter GBITS = 2;
reg dS;
reg[GBITS-1:0] dA,dB;
wire[GBITS-1:0] mY;
reg[GBITS-1:0] cY;

integer loop, ecnt;

initial begin
  ecnt = 0;
  for (loop=0;loop<2**(2*GBITS+1);loop=loop+1) begin
    {dS,dA,dB} = loop;
    #5;
    // get expected value
    if (dS==1'b0) cY = dA;
    else if (dS==1'b1) cY = dB;
    // check mY here!
    if (mY!=cY) begin
      $display("** Error at S=%b,A=%b,B=%b >> Y=%b ??",dS,dA,dB,mY);
      ecnt = ecnt + 1;
    end
    #5;
  end
  if (ecnt==0) begin
    $display("## Module dmux21 (%g-bit(s)) verified!",muxA.BITS);
  end
end

defparam muxA.BITS = GBITS;
dmux21 muxA (dS,dA,dB,mY);

endmodule
