module dmux41_tb ();
parameter GBITS = 2;
reg[1:0] dS;
reg[GBITS-1:0] dA,dB,dC,dD;
wire[GBITS-1:0] mY;
reg[GBITS-1:0] cY;

integer loop, ecnt;

initial begin
  ecnt = 0;
  for (loop=0;loop<2**(4*GBITS+2);loop=loop+1) begin
    {dS,dA,dB,dC,dD} = loop;
    #5;
    // get expected value
    if (dS==2'b00) cY = dA;
    else if (dS==2'b01) cY = dB;
    else if (dS==2'b10) cY = dC;
    else if (dS==2'b11) cY = dD;
    // check mY here!
    if (mY!=cY) begin
      $display("** Error at S=%b,A=%b,B=%b,C=%b,D=%b >> Y=%b ??",
        dS,dA,dB,dC,dD,mY);
      ecnt = ecnt + 1;
    end
    #5;
  end
  if (ecnt==0) begin
    $display("## Module dmux41 (%g-bit(s)) verified!",muxA.BITS);
  end
end

defparam muxA.BITS = GBITS;
dmux41 muxA (dS,dA,dB,dC,dD,mY);

endmodule
