module dreg_tb ();
parameter BITS = 4;

// clock generator
parameter CLKP = 10;
reg dclk;
always begin
  #(CLKP/2) dclk = ~dclk;
end

// monitor dreg internal value
always @(dut.tdat) begin
  $write("[%05g] dregQ=%b\n",$time,dut.tdat);
end

// monitor dreg odat line
wire[BITS-1:0] mdat;
//always @(mdat) begin
//  $write("[%05g] dregY=%b\n",$time,mdat);
//end

// task for register write
reg[BITS-1:0] ddat;
reg dwre;
task dreg_write ;
  input[BITS-1:0] dval;
  begin
    ddat = dval; dwre = 1'b1;
    $display("-- [%g] WR-dreg:'%b' ",$time,ddat);
    #(CLKP/2); // setup time
    // should latch here
    #(CLKP/2); // hold time
    // 1-cycle
    dwre = 1'b0;
  end
endtask

// task for register read
reg drde;
task dreg_read ;
  begin
    drde = 1'b1;
    #(CLKP/2); // setup time
    $display("-- [%g] RD-dreg:'%b' ",$time,mdat);
    #(CLKP/2); // hold time
    // 1-cycle
    drde = 1'b0;
  end
endtask

initial begin
  dclk = 0; dwre = 1'b0; drde = 1'b0;
  #(CLKP) dreg_write(4'h5);
  #(CLKP);
  dreg_read();
  dreg_write(4'ha);
  #(CLKP);
  dreg_read();
  $stop;
end

dreg dut (dclk,dwre,drde,ddat,mdat);

endmodule
