module rcount4_tb ();

reg dclk,drst,denb;
wire[3:0] mstt;

parameter CLKP = 10;
always begin
  #(CLKP/2) dclk = ~dclk;
end

task state_reset ;
  input integer step;
  begin
    $display("[%5g] Resetting state machine", $time);
    drst = 1;
    while (step) begin
      #CLKP;
      step = step - 1;
    end
    drst = 0;
  end
endtask

task state_cycle ;
  integer loop;
  begin
    denb = 1;
    for (loop=0;loop<4;loop=loop+1) begin
      #CLKP;
    end
    denb = 0;
  end
endtask

always @(mstt) begin
  if (denb==1'b1)
    $display("[%5g] State transition: %b",$time,mstt);
  else // reset?
    $display("[%5g] State reset: %b",$time,mstt);
end

initial begin
  // reset
  dclk = 0; denb = 0; drst = 0;
  #CLKP;
  state_reset(4);
  #CLKP;
  state_cycle();
  #CLKP;
  #CLKP;
  state_cycle();
  #CLKP;
  $stop;
end

rcount4 dut (dclk,drst,denb,mstt);

endmodule
