module regblock4dp_tb ();
parameter BITS = 4;
parameter CLKP = 10;
reg dclk,dwre,drde,dr2e;
reg[1:0] wsel,rsel,rs2l;
reg[BITS-1:0] ddat;
wire[BITS-1:0] mdat, md2t;

always begin
  #(CLKP/2) dclk = ~dclk;
end

task reg_move ; // call on -ve edge
  input[1:0] wadd, radd; // dst,src
  begin
    $display("-- mov R%g , R%g",wadd,radd);
    // read cycle
    rsel = radd; drde = 1'b1;
    #(CLKP);
    ddat = mdat;
    // write cycle
    wsel = wadd; dwre = 1'b1;
    #(CLKP);
    dwre = 1'b0; drde = 1'b0;
  end
endtask

task reg_mov2 ;
  input[1:0] wadd, radd;
  begin
    $display("-- mov2 R%g , R%g",wadd,radd);
    // read cycle
    rs2l = radd; dr2e = 1'b1;
    #(CLKP);
    ddat = md2t;
    // write cycle
    wsel = wadd; dwre = 1'b1;
    #(CLKP);
    dwre = 1'b0; dr2e = 1'b0;
  end
endtask

task reg_hack; // call on -ve edge
  input[1:0] hadd;
  input[BITS-1:0] hdat;
  begin
    // write cycle
    wsel = hadd; dwre = 1'b1;
    ddat = hdat;
    #(CLKP);
    dwre = 1'b0;
  end
endtask

always @(posedge dclk) begin
  if (drde===1'b1) begin
    $display("[%05g] R%g (%b) read1 value %h@(%b)",
      $time,rsel,rsel,mdat,mdat);
  end
  if (dwre===1'b1) begin
    $display("[%05g] R%g (%b) write value %h@(%b)",
      $time,wsel,wsel,ddat,ddat);
  end
end

always @(md2t) begin
  if (dr2e===1'b1) begin
    $display("[%05g] R%g (%b) read2 value %h@(%b)",
      $time,rs2l,rs2l,md2t,md2t);
  end
end

task reg_showall;
  begin
    $write("[%05g] Register Contents => { ",$time);
    $write("R0:%b ",dut.reg0.tdat);
    $write("R1:%b ",dut.reg1.tdat);
    $write("R2:%b ",dut.reg2.tdat);
    $write("R3:%b }\n",dut.reg3.tdat);
  end
endtask

initial begin
  // reset conditions
  dclk = 1'b0; dwre = 1'b0; drde = 1'b0; dr2e = 1'b0;
  reg_showall();
  #(CLKP);
  reg_hack(0,4'ha);
  reg_hack(1,2);
  reg_hack(2,5);
  reg_hack(3,12);
  #(CLKP);
  reg_move(3,0);
  reg_mov2(1,2);
  $stop;
end

regblock4dp dut (dclk,dwre,wsel,drde,rsel,dr2e,rs2l,ddat,mdat,md2t);

endmodule
