module zbuff_tb ();

parameter SIZE = 4;

reg dE;
reg[SIZE-1:0] dA;
wire[SIZE-1:0] mY;

integer loop, ecnt;

initial begin
  ecnt = 0;
  dE = 1'b1;
  for (loop=0;loop<2**SIZE;loop=loop+1) begin
    dA = loop;
    #5;
    if (mY!==dA) begin
      ecnt = ecnt + 1;
    end
    #5;
  end
  dE = 1'b0;
  for (loop=0;loop<2**SIZE;loop=loop+1) begin
    dA = loop;
    #5;
    if (mY!=={SIZE{1'bz}}) begin
      ecnt = ecnt + 1;
    end
    #5;
  end
  if (ecnt==0) $display("-- Module zbuff (%g-bit) verified",SIZE);
  else $display("** Module zbuff (%g-bit) with error(s) (%g)",SIZE,ecnt);
end

defparam dut.BITS = SIZE;
zbuff dut (dE,dA,mY);

endmodule
