#include "Aria.h"

int main(int argc, char *argv[])
{
	int status = 0;
	ArRobot robot;
	ArSimpleConnector connector(&argc, argv);
	ArKeyHandler keyHandler;
	ArActionConstantVelocity constantVelocity("Constant Velocity", 400); // default velocity

	Aria::init();
	Aria::setKeyHandler(&keyHandler);
	robot.attachKeyHandler(&keyHandler);
	if(connector.connectRobot(&robot))
	{
		printf("Connected to robot... start to do stuffs!\n");
		robot.enableMotors();
		robot.addAction(&constantVelocity, 25); // move at constant velocity, priority 25
		robot.run(true);
	}
	else
	{
		printf("Could not connect to robot... exiting!\n");
		status = 1;
	}
	Aria::shutdown();

	return status;
}